import { Job } from 'bullmq';
export interface OldTransactionsCleanupData {
    olderThanDays?: number;
    batchSize?: number;
    dryRun?: boolean;
}
export interface OldLogsCleanupData {
    olderThanDays?: number;
    logLevels?: string[];
    batchSize?: number;
    dryRun?: boolean;
}
export interface OldSessionsCleanupData {
    olderThanDays?: number;
    batchSize?: number;
    dryRun?: boolean;
}
export interface CleanupResult {
    success: boolean;
    jobType: string;
    itemsProcessed: number;
    itemsRemoved: number;
    errors?: string[];
    duration: number;
    dryRun: boolean;
}
export declare function processOldTransactionsCleanup(job: Job<OldTransactionsCleanupData>): Promise<CleanupResult>;
export declare function processOldLogsCleanup(job: Job<OldLogsCleanupData>): Promise<CleanupResult>;
export declare function processOldSessionsCleanup(job: Job<OldSessionsCleanupData>): Promise<CleanupResult>;
export declare function getCleanupProcessor(jobType: string): typeof processOldLogsCleanup;
