"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderInsufficientBalanceError = exports.InsufficientBalanceError = exports.ValidationError = exports.ProviderError = exports.VtuBillsError = void 0;
class VtuBillsError extends Error {
    code;
    statusCode;
    details;
    constructor(message, code, statusCode = 500, details) {
        super(message);
        this.code = code;
        this.statusCode = statusCode;
        this.details = details;
        this.name = 'VtuBillsError';
    }
}
exports.VtuBillsError = VtuBillsError;
class ProviderError extends VtuBillsError {
    constructor(message, provider, details) {
        super(message, 'PROVIDER_ERROR', 500, { provider, ...details });
        this.name = 'ProviderError';
    }
}
exports.ProviderError = ProviderError;
class ValidationError extends VtuBillsError {
    constructor(message, field) {
        super(message, 'VALIDATION_ERROR', 400, { field });
        this.name = 'ValidationError';
    }
}
exports.ValidationError = ValidationError;
class InsufficientBalanceError extends VtuBillsError {
    constructor(required, available) {
        super('Insufficient balance', 'INSUFFICIENT_BALANCE', 400, { required, available });
        this.name = 'InsufficientBalanceError';
    }
}
exports.InsufficientBalanceError = InsufficientBalanceError;
class ProviderInsufficientBalanceError extends VtuBillsError {
    constructor(provider, details) {
        super('Provider insufficient balance', 'INSUFFICIENT_PROVIDER_BALANCE', 503, { provider, ...details });
        this.name = 'ProviderInsufficientBalanceError';
    }
}
exports.ProviderInsufficientBalanceError = ProviderInsufficientBalanceError;
