import { VtuBillsProviderAdapter, ProviderConfig, ProviderName, ProviderRegistry, SandboxConfig, ProviderStatus, VtuRequest, VtuResponse, BillResponse, ElectricityBillRequest, CableBillRequest, EducationBillRequest, ElectricityValidationResponse, CableValidationResponse, ExamPinRequest, ExamPinResponse, DataPlan, NetworkInfo, TransactionQuery, Network, MeterType, CableProvider, ElectricityProvider } from './vtu-bills.types';
export declare class VtuBillsProviderManager {
    private static instance;
    private providers;
    private currentProvider;
    private sandboxConfig;
    private providerCircuitUntil;
    private circuitTtlMs;
    private providerStats;
    private constructor();
    static getInstance(): VtuBillsProviderManager;
    private initializeProviders;
    setProvider(providerName: ProviderName): void;
    getCurrentProvider(): ProviderName;
    getProvider(providerName?: ProviderName): VtuBillsProviderAdapter;
    getAllProviders(): ProviderRegistry;
    getProviderInfo(providerName?: ProviderName): {
        name: string;
        version: string;
        features: string[];
    };
    enableSandboxMode(): void;
    disableSandboxMode(): void;
    isSandboxMode(): boolean;
    getSandboxConfig(): SandboxConfig;
    updateSandboxConfig(config: Partial<SandboxConfig>): void;
    checkAllProvidersHealth(): Promise<Record<string, ProviderStatus>>;
    checkCurrentProviderHealth(): Promise<ProviderStatus>;
    private _getEnabledProviderOrder;
    private _getProviderOrderWithPreferences;
    private _recordProviderSuccess;
    private _recordProviderFailure;
    private _openCircuit;
    private _isCircuitOpen;
    buyAirtime(request: VtuRequest): Promise<VtuResponse>;
    buyData(request: VtuRequest): Promise<VtuResponse>;
    getDataPlans(network: Network): Promise<DataPlan[]>;
    getNetworks(): Promise<NetworkInfo[]>;
    payElectricityBill(request: ElectricityBillRequest): Promise<BillResponse>;
    payCableBill(request: CableBillRequest): Promise<BillResponse>;
    payEducationBill(request: EducationBillRequest): Promise<BillResponse>;
    validateElectricityMeter(meterNumber: string, provider: ElectricityProvider, meterType: MeterType): Promise<ElectricityValidationResponse>;
    validateCableIUC(smartCardNumber: string, provider: CableProvider): Promise<CableValidationResponse>;
    buyExamPin(request: ExamPinRequest): Promise<ExamPinResponse>;
    generateRechargePins(amount: number, quantity: number, reference: string): Promise<ExamPinResponse>;
    queryTransaction(query: TransactionQuery): Promise<any>;
    getTransactionHistory(filters?: Record<string, any>): Promise<any[]>;
    updateProviderConfig(providerName: ProviderName, config: Partial<ProviderConfig>): void;
    getProviderConfig(providerName?: ProviderName): ProviderConfig;
    getAvailableProviders(): Array<{
        name: ProviderName;
        info: {
            name: string;
            version: string;
            features: string[];
        };
    }>;
    getProviderStatus(): {
        currentProvider: ProviderName;
        sandboxMode: boolean;
        availableProviders: string[];
        totalProviders: number;
    };
}
export declare const vtuBillsProviderManager: VtuBillsProviderManager;
