import { VtuBillsProviderAdapter, VtuRequest, VtuResponse, BillResponse, ElectricityBillRequest, CableBillRequest, EducationBillRequest, ElectricityValidationResponse, CableValidationResponse, ExamPinRequest, ExamPinResponse, DataPlan, NetworkInfo, ProviderConfig, ProviderStatus, TransactionQuery, Network, MeterType, CableProvider, ElectricityProvider } from './vtu-bills.types';
export declare class ASBDataProvider implements VtuBillsProviderAdapter {
    private client;
    private config;
    private status;
    constructor(config: ProviderConfig);
    getProviderInfo(): {
        name: string;
        version: string;
        features: string[];
    };
    buyAirtime(request: VtuRequest): Promise<VtuResponse>;
    buyData(request: VtuRequest): Promise<VtuResponse>;
    getDataPlans(network: Network): Promise<DataPlan[]>;
    getNetworks(): Promise<NetworkInfo[]>;
    payElectricityBill(request: ElectricityBillRequest): Promise<BillResponse>;
    payCableBill(request: CableBillRequest): Promise<BillResponse>;
    payEducationBill(request: EducationBillRequest): Promise<BillResponse>;
    validateElectricityMeter(meterNumber: string, provider: ElectricityProvider, meterType: MeterType): Promise<ElectricityValidationResponse>;
    validateCableIUC(smartCardNumber: string, provider: CableProvider): Promise<CableValidationResponse>;
    buyExamPin(request: ExamPinRequest): Promise<ExamPinResponse>;
    generateRechargePins(amount: number, quantity: number, reference: string): Promise<ExamPinResponse>;
    queryTransaction(query: TransactionQuery): Promise<any>;
    getTransactionHistory(filters?: Record<string, any>): Promise<any[]>;
    checkHealth(): Promise<ProviderStatus>;
    updateConfig(config: Partial<ProviderConfig>): void;
    getConfig(): ProviderConfig;
    private validateVtuRequest;
    private validateElectricityRequest;
    private validateCableRequest;
    private validateEducationRequest;
    private mapNetworkToProvider;
    private mapNetworkToProviderId;
    private formatPhoneNumber;
    private mapProviderToNetwork;
    private getFallbackDataPlans;
}
