"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdempotencyError = exports.ProviderError = exports.AuthenticationError = exports.ValidationError = exports.VerificationError = void 0;
class VerificationError extends Error {
    code;
    statusCode;
    details;
    constructor(message, code, statusCode = 400, details) {
        super(message);
        this.code = code;
        this.statusCode = statusCode;
        this.details = details;
        this.name = 'VerificationError';
    }
}
exports.VerificationError = VerificationError;
class ValidationError extends VerificationError {
    constructor(message, details) {
        super(message, 'VALIDATION_ERROR', 400, details);
        this.name = 'ValidationError';
    }
}
exports.ValidationError = ValidationError;
class AuthenticationError extends VerificationError {
    constructor(message = 'Authentication failed') {
        super(message, 'AUTHENTICATION_ERROR', 401);
        this.name = 'AuthenticationError';
    }
}
exports.AuthenticationError = AuthenticationError;
class ProviderError extends VerificationError {
    constructor(message, statusCode = 500, details) {
        super(message, 'PROVIDER_ERROR', statusCode, details);
        this.name = 'ProviderError';
    }
}
exports.ProviderError = ProviderError;
class IdempotencyError extends VerificationError {
    constructor(message = 'Duplicate request detected') {
        super(message, 'IDEMPOTENCY_ERROR', 409);
        this.name = 'IdempotencyError';
    }
}
exports.IdempotencyError = IdempotencyError;
