export type VerificationType = 'nin' | 'bvn' | 'bvn_phone' | 'ipe' | 'personalization';
export interface VerificationRequest {
    idempotencyKey: string;
    type: VerificationType;
    data: any;
    metadata?: Record<string, any>;
}
export interface VerificationResponse {
    success: boolean;
    data?: any;
    error?: string;
    trackingId?: string;
    transactionId?: string;
    timestamp: number;
    idempotencyKey: string;
}
export interface NinVerificationRequest {
    nin?: string;
    first_name?: string;
    last_name?: string;
    gender?: 'male' | 'female';
    dob?: string;
    phone?: string;
    userId?: string;
}
export interface NinVerificationResponse {
    batchid: string;
    birthcountry: string;
    birthdate: string;
    birthlga: string;
    birthstate: string;
    cardstatus: string;
    centralID: string;
    educationallevel: string;
    email: string;
    emplymentstatus: string;
    firstname: string;
    gender: string;
    heigth: string;
    maritalstatus: string;
    middlename: string;
    nin: string;
    nok_address1: string;
    nok_firstname: string;
    nok_lga: string;
    nok_middlename: string;
    nok_postalcode: string;
    nok_state: string;
    nok_surname: string;
    nok_town: string;
    nspokenlang: string;
    ospokenlang: string;
    pfirstname: string;
    photo: string;
    pmiddlename: string;
    profession: string;
    psurname: string;
    religion: string;
    residence_AdressLine1: string;
    residence_Town: string;
    residence_lga: string;
    residence_state: string;
    residencestatus: string;
    signature: string;
    surname: string;
    telephoneno: string;
    title: string;
    trackingId: string;
}
export interface BvnVerificationRequest {
    BVN: string;
    userId?: string;
}
export interface BvnVerificationByPhoneRequest {
    phone: string;
    firstName?: string;
    lastName?: string;
    userId?: string;
}
export interface BvnVerificationResponse {
    adverseMediaReport: any;
    allValidationPassed: boolean;
    amlReport: any;
    businessId: string;
    country: string;
    createdAt: string;
    dataValidation: boolean;
    dateOfBirth: string;
    enrollmentBranch: string;
    enrollmentInstitution: any;
    firstName: string;
    gender: string;
    id: string;
    idNumber: string;
    image: string;
    isConsent: boolean;
    lastModifiedAt: string;
    lastName: string;
    metadata: Record<string, any>;
    middleName: string;
    mobile: string;
    nin: string;
    parentId: any;
    reason: any;
    requestedAt: string;
    requestedById: string;
    selfieValidation: boolean;
    shouldRetrivedNin: boolean;
    status: string;
    type: string;
}
export interface IpeClearanceRequest {
    type: string;
    tracking_ids: string[];
}
export interface IpeClearanceResponse {
    success: string;
    trans_id: number;
}
export interface IpeClearanceStatusResponse {
    [trackingId: string]: string;
}
export interface PersonalizationRequest {
    type: string;
    tracking_id: string;
}
export interface PersonalizationResponse {
    address: string;
    face: string;
    firstname: string;
    gender: string;
    image: string;
    lastname: string;
    message: string;
    middlename: string;
    nin: string;
    signature: any;
    state: string;
    status: string;
    town: string;
    trackingid: string;
}
export interface VerificationProviderConfig {
    baseUrl: string;
    apiKey: string;
    timeout?: number;
    retries?: number;
    sandboxMode?: boolean;
}
export interface ProviderInfo {
    name: string;
    version: string;
    features: string[];
    baseUrl: string;
}
export interface VerificationProviderAdapter {
    getProviderInfo(): ProviderInfo;
    updateConfig(config: Partial<VerificationProviderConfig>): void;
    verifyNin(request: NinVerificationRequest): Promise<NinVerificationResponse>;
    verifyBvn(request: BvnVerificationRequest): Promise<BvnVerificationResponse>;
    verifyBvnByPhone?(request: BvnVerificationByPhoneRequest): Promise<BvnVerificationResponse>;
    createIpeClearance(request: IpeClearanceRequest): Promise<IpeClearanceResponse>;
    getIpeClearanceStatus(transactionId: number): Promise<IpeClearanceStatusResponse>;
    createPersonalization(request: PersonalizationRequest): Promise<PersonalizationResponse>;
    healthCheck(): Promise<boolean>;
}
export declare class VerificationError extends Error {
    code: string;
    statusCode: number;
    details?: any | undefined;
    constructor(message: string, code: string, statusCode?: number, details?: any | undefined);
}
export declare class ValidationError extends VerificationError {
    constructor(message: string, details?: any);
}
export declare class AuthenticationError extends VerificationError {
    constructor(message?: string);
}
export declare class ProviderError extends VerificationError {
    constructor(message: string, statusCode?: number, details?: any);
}
export declare class IdempotencyError extends VerificationError {
    constructor(message?: string);
}
export interface WebhookEvent {
    type: string;
    data: any;
    timestamp: number;
    signature: string;
    idempotencyKey: string;
}
export interface WebhookPayload {
    event: string;
    data: any;
    timestamp: number;
    idempotencyKey: string;
}
export interface SandboxConfig {
    enabled: boolean;
    mockDelay?: number;
    mockResponses?: Record<string, any>;
    simulateErrors?: boolean;
    errorRate?: number;
}
export type ProviderName = 'unify' | 'mock' | 's8v';
export interface ProviderRegistry {
    [key: string]: VerificationProviderAdapter;
}
export type TransactionStatus = 'pending' | 'completed' | 'failed' | 'cancelled';
export interface VerificationTransaction {
    id: string;
    idempotencyKey: string;
    type: VerificationType;
    request: any;
    response?: any;
    status: TransactionStatus;
    provider: string;
    trackingId?: string;
    transactionId?: string;
    createdAt: Date;
    updatedAt: Date;
    metadata?: Record<string, any>;
    userId?: string;
}
