import { VerificationProviderAdapter, VerificationProviderConfig, ProviderInfo, NinVerificationRequest, NinVerificationResponse, BvnVerificationRequest, BvnVerificationResponse, IpeClearanceRequest, IpeClearanceResponse, IpeClearanceStatusResponse, PersonalizationRequest, PersonalizationResponse } from './verification.types';
export declare class UnifyProvider implements VerificationProviderAdapter {
    private client;
    private config;
    private circuitBreaker;
    private retryStrategy;
    constructor(config: VerificationProviderConfig);
    getProviderInfo(): ProviderInfo;
    updateConfig(config: Partial<VerificationProviderConfig>): void;
    verifyNin(request: NinVerificationRequest): Promise<NinVerificationResponse>;
    verifyBvn(request: BvnVerificationRequest): Promise<BvnVerificationResponse>;
    verifyBvnByPhone(request: {
        phone: string;
        firstName?: string;
        lastName?: string;
    }): Promise<BvnVerificationResponse>;
    createIpeClearance(request: IpeClearanceRequest): Promise<IpeClearanceResponse>;
    getIpeClearanceStatus(transactionId: number): Promise<IpeClearanceStatusResponse>;
    createPersonalization(request: PersonalizationRequest): Promise<PersonalizationResponse>;
    healthCheck(): Promise<boolean>;
    getCircuitBreakerStatus(): {
        state: import("./circuit-breaker").CircuitState;
        failureCount: number;
        successCount: number;
        lastFailureTime: number;
    };
    resetCircuitBreaker(): void;
    private validateNinRequest;
    private ensureApiKeyAvailable;
}
