import { VerificationProviderAdapter, VerificationProviderConfig, ProviderName, SandboxConfig, NinVerificationRequest, NinVerificationResponse, BvnVerificationRequest, BvnVerificationResponse, IpeClearanceRequest, IpeClearanceResponse, IpeClearanceStatusResponse, PersonalizationRequest, PersonalizationResponse } from './verification.types';
export declare class VerificationProviderManager {
    private static instance;
    private providers;
    private currentProvider;
    private sandboxConfig;
    private constructor();
    static getInstance(): VerificationProviderManager;
    setProvider(providerName: ProviderName): void;
    getCurrentProvider(): ProviderName;
    getProviderInfo(): any;
    getCurrentProviderName(): ProviderName;
    enableSandboxMode(): void;
    disableSandboxMode(): void;
    isSandboxMode(): boolean;
    updateSandboxConfig(config: Partial<SandboxConfig>): void;
    getSandboxConfig(): SandboxConfig;
    verifyNin(request: NinVerificationRequest): Promise<NinVerificationResponse>;
    verifyBvn(request: BvnVerificationRequest): Promise<BvnVerificationResponse>;
    createIpeClearance(request: IpeClearanceRequest): Promise<IpeClearanceResponse>;
    getIpeClearanceStatus(transactionId: number): Promise<IpeClearanceStatusResponse>;
    createPersonalization(request: PersonalizationRequest): Promise<PersonalizationResponse>;
    healthCheck(): Promise<boolean>;
    getRegisteredProviders(): string[];
    setCurrentProvider(provider: ProviderName): void;
    getProviderStatus(): Promise<Record<string, any>>;
    private initializeProviders;
    private getCurrentProviderInstance;
    updateCurrentProviderConfig(config: Partial<VerificationProviderConfig>): void;
    updateUnifyProviderConfig(apiKey: string, baseUrl?: string): void;
    createProviderInstance(providerName: ProviderName, overrides?: Partial<VerificationProviderConfig>): VerificationProviderAdapter;
}
export declare const verificationProviderManager: VerificationProviderManager;
