import { VerificationProviderAdapter, VerificationProviderConfig, ProviderInfo, NinVerificationRequest, NinVerificationResponse, BvnVerificationRequest, BvnVerificationResponse, IpeClearanceRequest, IpeClearanceResponse, IpeClearanceStatusResponse, PersonalizationRequest, PersonalizationResponse } from './verification.types';
export declare class MockProvider implements VerificationProviderAdapter {
    private config;
    private mockData;
    private transactionCounter;
    constructor(config: VerificationProviderConfig);
    getProviderInfo(): ProviderInfo;
    updateConfig(config: Partial<VerificationProviderConfig>): void;
    verifyNin(request: NinVerificationRequest): Promise<NinVerificationResponse>;
    verifyBvn(request: BvnVerificationRequest): Promise<BvnVerificationResponse>;
    createIpeClearance(request: IpeClearanceRequest): Promise<IpeClearanceResponse>;
    getIpeClearanceStatus(transactionId: number): Promise<IpeClearanceStatusResponse>;
    createPersonalization(request: PersonalizationRequest): Promise<PersonalizationResponse>;
    healthCheck(): Promise<boolean>;
    private initializeMockData;
    private simulateDelay;
    private shouldSimulateError;
    private generateRandomString;
    private generateRandomNIN;
    private generateTrackingId;
    private validateNinRequest;
}
