"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.__setTestAdapters = exports.getVtuAdapter = exports.getBillAdapter = void 0;
const paystack_1 = require("./paystack");
const provider_manager_1 = require("./vtu-bills/provider-manager");
let billAdapter = new paystack_1.PaystackStub();
let vtuAdapter = {
    async buyVtu(input) {
        const result = await provider_manager_1.vtuBillsProviderManager.buyAirtime({
            amount: input.amount,
            type: input.type,
            network: input.network,
            phone: input.phone,
            planCode: input.planCode,
            reference: input.reference,
            metadata: {},
        });
        return {
            success: !!result?.success || result?.status === 'successful',
            providerReference: result?.providerReference,
            meta: result?.meta,
        };
    },
};
const getBillAdapter = () => billAdapter;
exports.getBillAdapter = getBillAdapter;
const getVtuAdapter = () => vtuAdapter;
exports.getVtuAdapter = getVtuAdapter;
const __setTestAdapters = (opts = {}) => {
    if (process.env['NODE_ENV'] !== 'test')
        return;
    if (opts.bills) {
        billAdapter = {
            async payBill(input) {
                if (opts.bills === 'success') {
                    return { success: true, providerReference: `TEST-${input.reference}`, meta: { test: true } };
                }
                return { success: false };
            }
        };
    }
    if (opts.vtu) {
        vtuAdapter = {
            async buyVtu(input) {
                if (opts.vtu === 'success') {
                    return { success: true, providerReference: `TEST-${input.reference}`, meta: { test: true } };
                }
                return { success: false };
            }
        };
    }
};
exports.__setTestAdapters = __setTestAdapters;
