export interface BillProviderAdapter {
    payBill(input: {
        amount: number;
        customerId: string;
        productCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference?: string;
        token?: string;
        meta?: any;
    }>;
}
export interface VtuProviderAdapter {
    buyVtu(input: {
        amount: number;
        type: 'airtime' | 'data';
        network: 'mtn' | 'airtel' | 'glo' | '9mobile';
        phone: string;
        planCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference?: string;
        meta?: any;
    }>;
}
export declare const getBillAdapter: () => BillProviderAdapter;
export declare const getVtuAdapter: () => VtuProviderAdapter;
export declare const __setTestAdapters: (opts?: {
    bills?: "success" | "failure";
    vtu?: "success" | "failure";
}) => void;
