export interface PaystackChargeRequest {
    amount: number;
    email: string;
    reference: string;
    callback_url?: string;
    currency?: 'NGN' | 'USD';
    metadata?: Record<string, any>;
    channels?: string[];
    split_code?: string;
    transaction_charge?: number;
    bearer?: 'account' | 'subaccount';
    subaccount?: string;
    plan?: string;
    quantity?: number;
    invoice_limit?: number;
}
export interface PaystackChargeResponse {
    status: boolean;
    message: string;
    data: {
        authorization_url: string;
        access_code: string;
        reference: string;
        amount: number;
        currency: string;
        metadata?: Record<string, any>;
    };
}
export interface PaystackTransaction {
    id: number;
    domain: string;
    amount: number;
    currency: string;
    source: string;
    reason: string;
    recipient: number;
    status: string;
    transfer_code: string;
    created_at: string;
    updated_at: string;
}
export interface PaystackWebhookEvent {
    event: string;
    data: {
        id: number;
        domain: string;
        amount: number;
        currency: string;
        source: string;
        reason: string;
        recipient: number;
        status: string;
        transfer_code: string;
        created_at: string;
        updated_at: string;
        metadata?: Record<string, any>;
        reference: string;
        fees: number;
        customer: {
            id: number;
            first_name: string;
            last_name: string;
            email: string;
            customer_code: string;
            phone: string;
            metadata?: Record<string, any>;
            risk_action: string;
            international_format_phone: string;
        };
        authorization: {
            authorization_code: string;
            bin: string;
            last4: string;
            exp_month: string;
            exp_year: string;
            channel: string;
            card_type: string;
            bank: string;
            country_code: string;
            brand: string;
            reusable: boolean;
            signature: string;
            account_name: string;
        };
        plan: {
            id: number;
            name: string;
            plan_code: string;
            description: string;
            amount: number;
            interval: string;
            send_invoices: boolean;
            send_sms: boolean;
            hosted_page: boolean;
            hosted_page_url: string;
            hosted_page_summary: string;
            currency: string;
            migrate: boolean;
            is_cancelled: boolean;
            cancel_at_period_end: boolean;
            trialed: boolean;
            trial_start: string;
            trial_end: string;
        };
        subaccount: {
            id: number;
            subaccount_code: string;
            business_name: string;
            description: string;
            primary_contact_name: string;
            primary_contact_email: string;
            primary_contact_phone: string;
            metadata?: Record<string, any>;
            percentage_charge: number;
            settlement_bank: string;
            account_number: string;
        };
        split: {
            type: string;
            bearer_type: string;
            subaccount_code: string;
            transaction_charge: number;
            transaction_charge_currency: string;
            percentage_charge: number;
            split_code: string;
            fee_charge: number;
            merchant_fee: number;
            subaccount: {
                id: number;
                subaccount_code: string;
                business_name: string;
                description: string;
                primary_contact_name: string;
                primary_contact_email: string;
                primary_contact_phone: string;
                metadata?: Record<string, any>;
                percentage_charge: number;
                settlement_bank: string;
                account_number: string;
            };
        };
    };
}
export interface PaystackAdapter {
    initializeCharge(request: PaystackChargeRequest): Promise<PaystackChargeResponse>;
    verifyTransaction(reference: string): Promise<PaystackTransaction>;
    verifyWebhookSignature(signature: string | undefined, rawBody: string): boolean;
    processWebhookEvent(event: PaystackWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(startDate: string, endDate: string): Promise<PaystackTransaction[]>;
    refundTransaction(reference: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
}
export declare class PaystackIntegration implements PaystackAdapter {
    private client;
    private baseURL;
    constructor();
    initializeCharge(request: PaystackChargeRequest): Promise<PaystackChargeResponse>;
    verifyTransaction(reference: string): Promise<PaystackTransaction>;
    verifyWebhookSignature(signature: string | undefined, rawBody: string): boolean;
    processWebhookEvent(event: PaystackWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(startDate: string, endDate: string): Promise<PaystackTransaction[]>;
    refundTransaction(reference: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    payBill(input: {
        amount: number;
        customerId: string;
        productCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        token: string;
        meta: {
            authorization_url: string;
            access_code: string;
            reference: string;
            amount: number;
            currency: string;
            metadata?: Record<string, any>;
        };
    }>;
    buyVtu(input: {
        amount: number;
        type: 'airtime' | 'data';
        network: 'mtn' | 'airtel' | 'glo' | '9mobile';
        phone: string;
        planCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        meta: {
            authorization_url: string;
            access_code: string;
            reference: string;
            amount: number;
            currency: string;
            metadata?: Record<string, any>;
        };
    }>;
}
export declare class PaystackStub implements PaystackAdapter {
    initializeCharge(request: PaystackChargeRequest): Promise<PaystackChargeResponse>;
    verifyTransaction(reference: string): Promise<PaystackTransaction>;
    verifyWebhookSignature(_signature: string | undefined, _rawBody: string): boolean;
    processWebhookEvent(event: PaystackWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(_startDate: string, _endDate: string): Promise<PaystackTransaction[]>;
    refundTransaction(reference: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    payBill(input: {
        amount: number;
        customerId: string;
        productCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        meta: {
            stub: boolean;
        };
    }>;
    buyVtu(input: {
        amount: number;
        type: 'airtime' | 'data';
        network: 'mtn' | 'airtel' | 'glo' | '9mobile';
        phone: string;
        planCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        meta: {
            stub: boolean;
        };
    }>;
}
export declare const paystackAdapter: PaystackAdapter;
