export interface FlutterwaveChargeRequest {
    tx_ref: string;
    amount: number;
    currency: 'NGN' | 'USD' | 'EUR' | 'GBP';
    redirect_url?: string;
    customer: {
        email: string;
        phone_number?: string;
        name?: string;
    };
    customizations?: {
        title?: string;
        description?: string;
        logo?: string;
    };
    meta?: Record<string, any>;
    payment_options?: string;
    payment_plan?: string;
    subaccounts?: Array<{
        id: string;
        transaction_split_ratio: string;
    }>;
    payment_type?: 'card' | 'banktransfer' | 'ussd' | 'qr' | 'mobilemoney' | 'barter';
    is_permanent?: boolean;
    expires?: number;
}
export interface FlutterwaveChargeResponse {
    status: string;
    message: string;
    data: {
        link: string;
        tx_ref: string;
        flw_ref: string;
        amount: number;
        currency: string;
        meta?: Record<string, any>;
    };
}
export interface FlutterwaveTransaction {
    id: number;
    tx_ref: string;
    flw_ref: string;
    device_fingerprint: string;
    amount: number;
    currency: string;
    charged_amount: number;
    app_fee: number;
    merchant_fee: number;
    processor_response: string;
    auth_model: string;
    ip: string;
    narration: string;
    status: string;
    payment_type: string;
    created_at: string;
    updated_at: string;
    account_id: number;
    customer: {
        id: number;
        phone_number: string;
        name: string;
        email: string;
        created_at: string;
    };
    card?: {
        first_6digits: string;
        last_4digits: string;
        issuer: string;
        country: string;
        type: string;
        token: string;
        expiry: string;
    };
    meta?: Record<string, any>;
}
export interface FlutterwaveWebhookEvent {
    event: string;
    data: FlutterwaveTransaction;
}
export interface FlutterwaveAdapter {
    initializeCharge(request: FlutterwaveChargeRequest): Promise<FlutterwaveChargeResponse>;
    verifyTransaction(transactionId: string): Promise<FlutterwaveTransaction>;
    verifyWebhookSignature(signature: string | undefined, rawBody: string): boolean;
    processWebhookEvent(event: FlutterwaveWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(startDate: string, endDate: string): Promise<FlutterwaveTransaction[]>;
    refundTransaction(transactionId: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    validateBankAccount(accountNumber: string, _accountBank: string): Promise<{
        status: string;
        message: string;
        data: {
            account_number: string;
            account_name: string;
            bank_id: number;
        };
    }>;
}
export declare class FlutterwaveIntegration implements FlutterwaveAdapter {
    private client;
    private baseURL;
    constructor();
    initializeCharge(request: FlutterwaveChargeRequest): Promise<FlutterwaveChargeResponse>;
    verifyTransaction(transactionId: string): Promise<FlutterwaveTransaction>;
    verifyWebhookSignature(signature: string | undefined, rawBody: string): boolean;
    processWebhookEvent(event: FlutterwaveWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(startDate: string, endDate: string): Promise<FlutterwaveTransaction[]>;
    refundTransaction(transactionId: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    validateBankAccount(accountNumber: string, _accountBank: string): Promise<{
        status: string;
        message: string;
        data: {
            account_number: string;
            account_name: string;
            bank_id: number;
        };
    }>;
    payBill(input: {
        amount: number;
        customerId: string;
        productCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        token: string;
        meta: {
            link: string;
            tx_ref: string;
            flw_ref: string;
            amount: number;
            currency: string;
            meta?: Record<string, any>;
        };
    }>;
    buyVtu(input: {
        amount: number;
        type: 'airtime' | 'data';
        network: 'mtn' | 'airtel' | 'glo' | '9mobile';
        phone: string;
        planCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        meta: {
            link: string;
            tx_ref: string;
            flw_ref: string;
            amount: number;
            currency: string;
            meta?: Record<string, any>;
        };
    }>;
}
export declare class FlutterwaveStub implements FlutterwaveAdapter {
    initializeCharge(request: FlutterwaveChargeRequest): Promise<FlutterwaveChargeResponse>;
    verifyTransaction(transactionId: string): Promise<FlutterwaveTransaction>;
    verifyWebhookSignature(_signature: string | undefined, _rawBody: string): boolean;
    processWebhookEvent(event: FlutterwaveWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(_startDate: string, _endDate: string): Promise<FlutterwaveTransaction[]>;
    refundTransaction(transactionId: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    validateBankAccount(accountNumber: string, _accountBank: string): Promise<{
        status: string;
        message: string;
        data: {
            account_number: string;
            account_name: string;
            bank_id: number;
        };
    }>;
    payBill(input: {
        amount: number;
        customerId: string;
        productCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        token: undefined;
        meta: {
            stub: boolean;
        };
    }>;
    buyVtu(input: {
        amount: number;
        type: 'airtime' | 'data';
        network: 'mtn' | 'airtel' | 'glo' | '9mobile';
        phone: string;
        planCode?: string;
        reference: string;
    }): Promise<{
        success: boolean;
        providerReference: string;
        meta: {
            stub: boolean;
        };
    }>;
}
export declare const flutterwaveAdapter: FlutterwaveAdapter;
