import { ServiceProviderDocument, ServiceType } from '../database/models/service-provider';
import { VtuBillsProviderAdapter, VtuRequest, VtuResponse, BillResponse, Network, VtuType } from './vtu-bills/vtu-bills.types';
export interface ConfigurableProviderAdapter extends VtuBillsProviderAdapter {
    providerId: string;
    providerConfig: ServiceProviderDocument;
}
export declare class ConfigurableServiceManager {
    private static instance;
    private providerCache;
    private planCache;
    private cacheExpiry;
    private readonly CACHE_TTL;
    private constructor();
    static getInstance(): ConfigurableServiceManager;
    getProvider(serviceType: ServiceType, fallbackOnFailure?: boolean): Promise<ConfigurableProviderAdapter>;
    getServicePlans(type: VtuType, network?: Network, filters?: any): Promise<any[]>;
    executeVtuPurchase(request: VtuRequest): Promise<VtuResponse>;
    executeBillPayment(request: any): Promise<BillResponse>;
    getPlanById(planId: string, providerId?: string): Promise<any | null>;
    calculatePrice(planId: string, providerId?: string): Promise<{
        basePrice: number;
        sellingPrice: number;
        markup: number;
    }>;
    validateServiceAvailability(serviceType: ServiceType, service: string): Promise<boolean>;
    getServiceStats(): Promise<{
        providers: any;
        plans: any;
        healthStatus: Record<string, any>;
    }>;
    clearCache(key?: string): void;
    private createProviderAdapter;
    private isCacheValid;
    private cleanupCache;
}
export declare const configurableServiceManager: ConfigurableServiceManager;
