"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAspfiyAdapterMode = getAspfiyAdapterMode;
exports.setAspfiyAdapterMode = setAspfiyAdapterMode;
const env_1 = require("../../config/env");
let runtimeModeOverride;
function getAspfiyAdapterMode() {
    if (runtimeModeOverride)
        return runtimeModeOverride;
    const flag = env_1.env.ASPFIY_USE_STUB;
    return flag ? "stub" : "real";
}
function setAspfiyAdapterMode(mode) {
    runtimeModeOverride = mode;
}
