export interface AspfiyChargeRequest {
    amount: number;
    email: string;
    reference: string;
    callback_url?: string;
    currency?: "NGN";
    customer_name?: string;
    customer_phone?: string;
    metadata?: Record<string, any>;
    payment_type?: "reserved_account" | "dynamic_account" | "bank_transfer";
}
export interface AspfiyChargeResponse {
    status: boolean;
    message: string;
    data: {
        authorization_url?: string;
        account_number?: string;
        account_name?: string;
        bank_name?: string;
        reference: string;
        amount: number;
        currency: string;
        metadata?: Record<string, any>;
        expires_at?: string;
    };
}
export interface AspfiyTransaction {
    id: string;
    reference: string;
    amount: number;
    currency: string;
    status: "pending" | "successful" | "failed" | "cancelled" | "success";
    payment_type: string;
    account_number?: string;
    account_name?: string;
    bank_name?: string;
    customer_email: string;
    customer_name?: string;
    customer_phone?: string;
    created_at: string;
    updated_at: string;
    metadata?: Record<string, any>;
    fees?: number;
    net_amount?: number;
    type?: string;
    wiaxy_ref?: string;
    transaction_ref?: string;
    merchant_reference?: string;
    account?: {
        account_number: string;
        account_name: string;
        bank_name: string;
        created_at: string;
    };
    customer?: {
        firstName: string;
        lastName: string;
        email: string;
    };
    payer?: {
        account_number: string;
        account_name: string;
        bank_name: string;
        created_at: string;
    };
}
export interface AspfiyWebhookEvent {
    event: string;
    data: AspfiyTransaction;
}
export interface AspfiyReservedAccountRequest {
    customer_email: string;
    customer_name?: string;
    customer_phone?: string;
    reference: string;
    metadata?: Record<string, any>;
    provider?: "paga" | "palmpay";
}
export interface AspfiyReservedAccountResponse {
    status: boolean;
    message: string;
    data: {
        account_number: string;
        account_name: string;
        bank_name: string;
        bank_code?: string;
        reference: string;
        customer_email: string;
        created_at: string;
        metadata?: Record<string, any>;
    };
}
export interface AspfiyDynamicAccountRequest {
    amount: number;
    customer_email: string;
    customer_name?: string;
    customer_phone?: string;
    reference: string;
    expires_in?: number;
    metadata?: Record<string, any>;
}
export interface AspfiyDynamicAccountResponse {
    status: boolean;
    message: string;
    data: {
        account_number: string;
        account_name: string;
        bank_name: string;
        reference: string;
        amount: number;
        currency: string;
        expires_at: string;
        customer_email: string;
        created_at: string;
        metadata?: Record<string, any>;
    };
}
export interface AspfiyBank {
    id: number;
    name: string;
    code: string;
    longcode: string;
    gateway: string;
    pay_with_bank: boolean;
    active: boolean;
    is_deleted: boolean;
    country: string;
    currency: string;
    type: string;
    createdAt: string;
    updatedAt: string;
}
export interface AspfiyAccountResolutionRequest {
    account_number: string;
    bank_code: string;
}
export interface AspfiyAccountResolutionResponse {
    status: boolean;
    message: string;
    data: {
        account_number: string;
        account_name: string;
        bank_id: number;
        bank_name: string;
    };
}
export interface AspfiyTransferRequest {
    amount: number;
    reference: string;
    recipient_account: string;
    recipient_bank_code: string;
    recipient_name?: string;
    narration?: string;
    metadata?: Record<string, any>;
}
export interface AspfiyTransferResponse {
    status: boolean;
    message: string;
    data: {
        reference: string;
        amount: number;
        currency: string;
        recipient_account: string;
        recipient_bank_code: string;
        recipient_name?: string;
        narration?: string;
        status: "pending" | "processing" | "successful" | "failed";
        created_at: string;
        updated_at: string;
        metadata?: Record<string, any>;
    };
}
export interface AspfiyBankListResponse {
    status: boolean;
    message: string;
    data: {
        id: number;
        name: string;
        code: string;
        longcode?: string;
        country?: string;
        currency?: string;
        type?: string;
        active: boolean;
    }[];
}
export interface AspfiyResolveAccountResponse {
    status: boolean;
    message: string;
    data: {
        account_number: string;
        account_name: string;
        bank_code: string;
    };
}
export interface AspfiyRefundRequest {
    transaction: string;
    amount?: number;
    reason?: string;
}
export interface AspfiyRefundResponse {
    status: boolean;
    message: string;
    data: {
        id: string;
        transaction: string;
        amount: number;
        currency: string;
        status: "pending" | "processed" | "failed";
        refunded_at?: string;
        created_at: string;
    };
}
export interface AspfiyTransactionVerifyResponse {
    status: boolean;
    message: string;
    data: {
        id: string;
        reference: string;
        amount: number;
        currency: string;
        status: "success" | "failed" | "pending";
        gateway_response?: string;
        paid_at?: string;
        created_at: string;
        customer: {
            id: string;
            email: string;
            name?: string;
            phone?: string;
        };
        authorization?: {
            authorization_code: string;
            bin: string;
            last4: string;
            exp_month: string;
            exp_year: string;
            channel: string;
            reusable: boolean;
            signature?: string;
        };
        [key: string]: any;
    };
}
export interface AspfiyAdapter {
    initializeCharge(request: AspfiyChargeRequest): Promise<AspfiyChargeResponse>;
    verifyTransaction(reference: string): Promise<AspfiyTransaction>;
    verifyWebhookSignature(signature: string | undefined, rawBody: string): boolean;
    processWebhookEvent(event: AspfiyWebhookEvent): Promise<{
        success: boolean;
        transactionId: string;
        status: string;
        amount: number;
        metadata?: Record<string, any>;
    }>;
    reconcileTransactions(startDate: string, endDate: string): Promise<AspfiyTransaction[]>;
    refundTransaction(reference: string, amount?: number): Promise<{
        success: boolean;
        refundId: string;
        amount: number;
    }>;
    createReservedAccount(request: AspfiyReservedAccountRequest): Promise<AspfiyReservedAccountResponse>;
    createDynamicAccount(request: AspfiyDynamicAccountRequest): Promise<AspfiyDynamicAccountResponse>;
    getBanks(): Promise<AspfiyBank[]>;
    resolveAccount(request: AspfiyAccountResolutionRequest): Promise<AspfiyAccountResolutionResponse>;
    initiateTransfer(request: AspfiyTransferRequest): Promise<AspfiyTransferResponse>;
}
