import { AspfiyChargeRequest, AspfiyChargeResponse, AspfiyReservedAccountRequest, AspfiyReservedAccountResponse, AspfiyDynamicAccountRequest, AspfiyDynamicAccountResponse, AspfiyTransferRequest, AspfiyTransferResponse, AspfiyBankListResponse, AspfiyResolveAccountResponse, AspfiyWebhookEvent, AspfiyRefundRequest, AspfiyRefundResponse, AspfiyTransactionVerifyResponse } from './types';
import { getAspfiyAdapterMode, setAspfiyAdapterMode } from './utils';
import { AspfiyAdapter } from './types';
export declare class AspfiyIntegration {
    private client;
    private mode;
    private endpoints;
    constructor();
    private handleError;
    chargeCustomer(request: AspfiyChargeRequest): Promise<AspfiyChargeResponse>;
    createReservedAccount(request: AspfiyReservedAccountRequest): Promise<AspfiyReservedAccountResponse>;
    createDynamicAccount(request: AspfiyDynamicAccountRequest): Promise<AspfiyDynamicAccountResponse>;
    initiateTransfer(request: AspfiyTransferRequest): Promise<AspfiyTransferResponse>;
    getBanks(): Promise<AspfiyBankListResponse>;
    resolveAccount(bankCode: string, accountNumber: string): Promise<AspfiyResolveAccountResponse>;
    refundTransaction(request: AspfiyRefundRequest): Promise<AspfiyRefundResponse>;
    verifyTransaction(reference: string): Promise<AspfiyTransactionVerifyResponse>;
    verifyWebhookSignature(payload: string, signature: string): boolean;
    handleWebhook(event: AspfiyWebhookEvent): AspfiyWebhookEvent;
}
export declare const aspfiyAdapter: AspfiyAdapter;
export { getAspfiyAdapterMode, setAspfiyAdapterMode };
