import mongoose from 'mongoose';
export declare const objectIdToString: (id: mongoose.Types.ObjectId | string) => string;
export declare const stringToObjectId: (id: string) => mongoose.Types.ObjectId;
export declare const isValidObjectId: (id: string) => boolean;
export declare const generateObjectId: () => mongoose.Types.ObjectId;
export declare const toPlainObject: <T>(doc: mongoose.Document | T) => T;
export declare const toJSON: <T>(doc: mongoose.Document | T) => T;
export declare const createFilter: <T>(filter: Partial<T>) => Record<string, any>;
export declare const createSort: (sort: Record<string, 1 | -1>) => Record<string, 1 | -1>;
export declare const createPagination: (page?: number, limit?: number) => {
    skip: number;
    limit: number;
    page: number;
};
export declare const applyPagination: <T>(query: mongoose.Query<T[], T>, page?: number, limit?: number) => mongoose.Query<T[], T>;
export declare const createTextSearch: (searchTerm: string, fields: string[]) => Record<string, any>;
export declare const createDateRangeFilter: (startDate?: Date, endDate?: Date, field?: string) => Record<string, any>;
export declare const createNumericRangeFilter: (field: string, min?: number, max?: number) => Record<string, any>;
export declare const sanitizeQuery: (query: Record<string, any>) => Record<string, any>;
export declare const createAggregationPipeline: (options: {
    match?: Record<string, any>;
    sort?: Record<string, 1 | -1>;
    skip?: number;
    limit?: number;
    lookup?: Array<{
        from: string;
        localField: string;
        foreignField: string;
        as: string;
    }>;
    group?: Record<string, any>;
    project?: Record<string, any>;
}) => any[];
