"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.seedTestUserAndWallet = void 0;
const connection_1 = require("../../database/connection");
const mongoose_1 = __importDefault(require("mongoose"));
const user_model_1 = require("../../modules/users/user.model");
const wallet_1 = require("../../database/models/wallet");
const seedTestUserAndWallet = async () => {
    await (0, connection_1.initializeDatabase)();
    try {
        const email = 'test@example.com';
        let user = await user_model_1.User.findOne({ email });
        if (!user) {
            user = await user_model_1.User.create({ email, passwordHash: 'dummy', role: 'user', isEmailVerified: true });
        }
        let wallet = await wallet_1.Wallet.findOne({ userId: user.id, currency: 'NGN' });
        if (!wallet) {
            wallet = await wallet_1.Wallet.create({ userId: new mongoose_1.default.Types.ObjectId(user.id), currency: 'NGN', availableBalance: 100000, ledgerBalance: 100000 });
        }
        console.log('Seeded user and wallet:', { user: user.toJSON(), wallet: wallet.toJSON() });
    }
    finally {
        await (0, connection_1.closeDatabase)();
    }
};
exports.seedTestUserAndWallet = seedTestUserAndWallet;
if (require.main === module) {
    (0, exports.seedTestUserAndWallet)().catch((e) => { console.error(e); process.exit(1); });
}
