"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.walletRepository = exports.WalletRepository = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const base_1 = require("./base");
const wallet_1 = require("../models/wallet");
class WalletRepository extends base_1.BaseRepository {
    model = wallet_1.Wallet;
    softDeleteEnabled = true;
    isValidId(id) {
        return mongoose_1.default.Types.ObjectId.isValid(id);
    }
    async findByUserCurrency(userId, currency) {
        return this.model.findOne({ userId: new mongoose_1.default.Types.ObjectId(userId), currency });
    }
    async adjustBalance(walletId, delta) {
        if (!this.isValidId(walletId))
            return null;
        return this.model.findOneAndUpdate({ _id: walletId }, { $inc: { availableBalance: delta, ledgerBalance: delta } }, { new: true });
    }
    async setLastTransactionAt(walletId, date) {
        if (!this.isValidId(walletId))
            return;
        await this.model.updateOne({ _id: walletId }, { $set: { lastTransactionAt: date } });
    }
    async updateBalance(walletId, availableBalance, ledgerBalance) {
        if (!this.isValidId(walletId))
            return null;
        return this.model.findOneAndUpdate({ _id: walletId }, { $set: { availableBalance, ledgerBalance } }, { new: true });
    }
}
exports.WalletRepository = WalletRepository;
exports.walletRepository = new WalletRepository();
