import mongoose from 'mongoose';
import { BaseRepository } from './base';
import { WalletDocument } from '../models/wallet';
export declare class WalletRepository extends BaseRepository<WalletDocument> {
    protected model: mongoose.Model<WalletDocument, {}, {}, {}, mongoose.Document<unknown, {}, WalletDocument, {}, {}> & WalletDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    protected softDeleteEnabled: boolean;
    protected isValidId(id: string): boolean;
    findByUserCurrency(userId: string, currency: string): Promise<WalletDocument | null>;
    adjustBalance(walletId: string, delta: number): Promise<WalletDocument | null>;
    setLastTransactionAt(walletId: string, date: Date): Promise<void>;
    updateBalance(walletId: string, availableBalance: number, ledgerBalance: number): Promise<WalletDocument | null>;
}
export declare const walletRepository: WalletRepository;
