"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.vtuRepository = exports.VtuRepository = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const base_1 = require("./base");
const vtu_1 = require("../models/vtu");
class VtuRepository extends base_1.BaseRepository {
    model = vtu_1.VtuOrder;
    softDeleteEnabled = true;
    isValidId(id) {
        return mongoose_1.default.Types.ObjectId.isValid(id);
    }
    async updateStatus(id, status, meta) {
        if (!this.isValidId(id))
            return;
        const update = { status };
        if (meta)
            update.metadata = meta;
        await this.model.updateOne({ _id: id }, { $set: update });
    }
    async findByProviderRef(providerReference) {
        return this.model.findOne({ providerReference });
    }
}
exports.VtuRepository = VtuRepository;
exports.vtuRepository = new VtuRepository();
