"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verificationRepository = exports.VerificationRepository = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const base_1 = require("./base");
const verification_1 = require("../models/verification");
class VerificationRepository extends base_1.BaseRepository {
    model = verification_1.VerificationRequest;
    softDeleteEnabled = true;
    isValidId(id) {
        return mongoose_1.default.Types.ObjectId.isValid(id);
    }
    async upsert(userId, type, target, updates) {
        const filter = { userId, type, target };
        const update = { $set: updates };
        const options = { upsert: true, new: true, setDefaultsOnInsert: true };
        return this.model.findOneAndUpdate(filter, update, options);
    }
    async updateStatus(id, status, result, errorMessage) {
        if (!this.isValidId(id))
            return;
        const update = { status };
        if (result)
            update.result = result;
        if (errorMessage)
            update.errorMessage = errorMessage;
        await this.model.updateOne({ _id: id }, { $set: update });
    }
}
exports.VerificationRepository = VerificationRepository;
exports.verificationRepository = new VerificationRepository();
