import mongoose from 'mongoose';
import { BaseRepository } from './base';
import { VerificationRequestDocument, VerificationType, VerificationStatus } from '../models/verification';
export declare class VerificationRepository extends BaseRepository<VerificationRequestDocument> {
    protected model: mongoose.Model<VerificationRequestDocument, {}, {}, {}, mongoose.Document<unknown, {}, VerificationRequestDocument, {}, {}> & VerificationRequestDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    protected softDeleteEnabled: boolean;
    protected isValidId(id: string): boolean;
    upsert(userId: string, type: VerificationType, target: string, updates: Partial<VerificationRequestDocument>): Promise<VerificationRequestDocument>;
    updateStatus(id: string, status: VerificationStatus, result?: Record<string, any>, errorMessage?: string): Promise<void>;
}
export declare const verificationRepository: VerificationRepository;
