import mongoose from 'mongoose';
import { BaseRepository } from './base';
import { TransactionDocument, TransactionStatus, TransactionCategory, TransactionType } from '../models/transactions';
export interface TransactionSearchParams {
    userId?: string;
    walletId?: string;
    type?: TransactionType;
    category?: TransactionCategory;
    status?: TransactionStatus;
    currency?: 'NGN' | 'USD';
    dateFrom?: Date;
    dateTo?: Date;
    minAmount?: number;
    maxAmount?: number;
    reference?: string;
    externalReference?: string;
    journalEntryId?: string;
    isReversal?: boolean;
}
export interface TransactionExportParams extends TransactionSearchParams {
    format: 'csv' | 'json';
    includeMetadata?: boolean;
}
export declare class TransactionRepository extends BaseRepository<TransactionDocument> {
    protected model: mongoose.Model<TransactionDocument, {}, {}, {}, mongoose.Document<unknown, {}, TransactionDocument, {}, {}> & TransactionDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    protected isValidId(id: string): boolean;
    findByReference(reference: string): Promise<TransactionDocument | null>;
    markStatus(id: string, status: TransactionStatus): Promise<void>;
    getJournalEntry(journalEntryId: string): Promise<TransactionDocument[]>;
    getRelatedTransactions(transactionId: string): Promise<TransactionDocument[]>;
    exportTransactions(params: TransactionExportParams): Promise<string>;
    private toCSV;
    getTransactionStats(params: TransactionSearchParams): Promise<any>;
    findOldTransactions(cutoffDate: Date, batchSize?: number): Promise<(mongoose.FlattenMaps<TransactionDocument> & Required<{
        _id: mongoose.FlattenMaps<unknown>;
    }> & {
        __v: number;
    })[]>;
    deleteOldTransactions(cutoffDate: Date): Promise<mongoose.mongo.DeleteResult>;
    getCategoryBreakdown(startDate: Date, endDate: Date): Promise<any[]>;
    searchTransactions(params: any, page?: number, limit?: number): Promise<{
        data: (mongoose.FlattenMaps<TransactionDocument> & Required<{
            _id: mongoose.FlattenMaps<unknown>;
        }> & {
            __v: number;
        })[];
        pagination: {
            page: number;
            limit: number;
            total: number;
            pages: number;
        };
    }>;
}
export declare const transactionRepository: TransactionRepository;
