import { ServiceProviderDocument, ServiceType, ProviderStatus } from '../models/service-provider';
import { BaseRepository } from './base';
export interface ServiceProviderFilters {
    serviceType?: ServiceType;
    status?: ProviderStatus;
    supportedServices?: string[];
    isHealthy?: boolean;
    sandboxMode?: boolean;
}
export interface ServiceProviderCreateData {
    name: string;
    slug: string;
    displayName: string;
    serviceType: ServiceType;
    baseUrl: string;
    apiKey: string;
    secretKey?: string;
    webhookUrl?: string;
    timeout?: number;
    retryAttempts?: number;
    sandboxMode?: boolean;
    priority?: number;
    defaultMarkup?: number;
    supportedServices: string[];
    supportedNetworks?: string[];
    rateLimitPerMinute?: number;
    rateLimitPerHour?: number;
    minimumBalance?: number;
}
export interface ServiceProviderUpdateData extends Partial<ServiceProviderCreateData> {
    status?: ProviderStatus;
    isHealthy?: boolean;
    errorCount?: number;
    successRate?: number;
    lastHealthCheck?: Date;
}
export declare class ServiceProviderRepository extends BaseRepository<ServiceProviderDocument> {
    protected model: import("mongoose").Model<ServiceProviderDocument, {}, {}, {}, import("mongoose").Document<unknown, {}, ServiceProviderDocument, {}, {}> & ServiceProviderDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    constructor();
    findByServiceType(serviceType: ServiceType, filters?: Partial<ServiceProviderFilters>): Promise<ServiceProviderDocument[]>;
    findBySlug(slug: string): Promise<ServiceProviderDocument | null>;
    findActiveProviders(serviceType?: ServiceType): Promise<ServiceProviderDocument[]>;
    findByPriority(serviceType: ServiceType, limit?: number): Promise<ServiceProviderDocument[]>;
    updateHealthStatus(id: string, healthData: {
        isHealthy: boolean;
        errorCount?: number;
        successRate?: number;
        lastHealthCheck?: Date;
    }): Promise<ServiceProviderDocument | null>;
    incrementErrorCount(id: string): Promise<ServiceProviderDocument | null>;
    resetErrorCount(id: string): Promise<ServiceProviderDocument | null>;
    findBySupportedService(service: string, serviceType?: ServiceType): Promise<ServiceProviderDocument[]>;
    getProviderStats(): Promise<{
        total: number;
        active: number;
        inactive: number;
        healthy: number;
        byServiceType: Record<string, number>;
    }>;
    searchProviders(searchTerm: string, filters?: ServiceProviderFilters): Promise<ServiceProviderDocument[]>;
}
export declare const serviceProviderRepository: ServiceProviderRepository;
