import { ServicePlanDocument, PlanType, Network, PlanStatus } from '../models/service-plan';
import { BaseRepository } from './base';
export interface ServicePlanFilters {
    type?: PlanType;
    network?: Network;
    status?: PlanStatus;
    isVisible?: boolean;
    providerId?: string;
    minPrice?: number;
    maxPrice?: number;
    category?: string;
}
export interface ServicePlanCreateData {
    providerId: string;
    planId: string;
    vendorPlanId?: string;
    name: string;
    description?: string;
    type: PlanType;
    category?: string;
    network?: Network;
    dataPlanType?: string;
    size?: string;
    validity?: string;
    amount: number;
    sellingPrice: number;
    status?: PlanStatus;
    isVisible?: boolean;
    stockQuantity?: number;
    minPurchase?: number;
    maxPurchase?: number;
    dailyLimit?: number;
    metadata?: Record<string, any>;
}
export interface ServicePlanUpdateData extends Partial<ServicePlanCreateData> {
    totalSales?: number;
    successRate?: number;
    lastSaleDate?: Date;
}
export declare class ServicePlanRepository extends BaseRepository<ServicePlanDocument> {
    protected model: import("mongoose").Model<ServicePlanDocument, {}, {}, {}, import("mongoose").Document<unknown, {}, ServicePlanDocument, {}, {}> & ServicePlanDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    constructor();
    findByType(type: PlanType, filters?: Partial<ServicePlanFilters>): Promise<ServicePlanDocument[]>;
    findByNetwork(network: Network, type?: PlanType): Promise<ServicePlanDocument[]>;
    findByProvider(providerId: string, filters?: Partial<ServicePlanFilters>): Promise<ServicePlanDocument[]>;
    findActivePlans(filters?: ServicePlanFilters): Promise<ServicePlanDocument[]>;
    findByPlanId(planId: string, providerId?: string): Promise<ServicePlanDocument | null>;
    findDataPlans(network: Network, dataPlanType?: string): Promise<ServicePlanDocument[]>;
    findElectricityPlans(discoName?: string): Promise<ServicePlanDocument[]>;
    findCablePlans(cableProvider?: string): Promise<ServicePlanDocument[]>;
    updateSalesStats(id: string, saleAmount: number, success: boolean): Promise<ServicePlanDocument | null>;
    searchPlans(searchTerm: string, filters?: ServicePlanFilters): Promise<ServicePlanDocument[]>;
    getPlanStats(): Promise<{
        total: number;
        active: number;
        inactive: number;
        visible: number;
        byType: Record<string, number>;
        byNetwork: Record<string, number>;
        averagePrice: number;
    }>;
    bulkUpdatePrices(providerId: string, markupPercentage: number): Promise<{
        modifiedCount: number;
    }>;
    findDistinctDataPlanTypes(): Promise<string[]>;
}
export declare const servicePlanRepository: ServicePlanRepository;
