"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serviceConfigurationRepository = exports.ServiceConfigurationRepository = void 0;
const base_1 = require("./base");
const service_configuration_1 = require("../models/service-configuration");
class ServiceConfigurationRepository extends base_1.BaseRepository {
    model = service_configuration_1.ServiceConfiguration;
    constructor() {
        super();
    }
    async getByKey(key, scope, opts) {
        const query = { key, scope, isDeleted: { $ne: true } };
        if (opts?.serviceType)
            query.serviceType = opts.serviceType;
        if (opts?.providerId)
            query.providerId = opts.providerId;
        if (opts?.planId)
            query.planId = opts.planId;
        return this.model.findOne(query).lean().exec();
    }
    async upsert(data) {
        const filter = {
            key: data.key,
            scope: data.scope,
            serviceType: data.serviceType,
            providerId: data.providerId,
            planId: data.planId,
            isDeleted: { $ne: true },
        };
        const update = { $set: { ...data } };
        const options = { upsert: true, new: true, setDefaultsOnInsert: true };
        const doc = await this.model.findOneAndUpdate(filter, update, options).lean().exec();
        return doc;
    }
    async listByCategory(category) {
        return this.model.find({ category, isDeleted: { $ne: true } }).lean().exec();
    }
}
exports.ServiceConfigurationRepository = ServiceConfigurationRepository;
exports.serviceConfigurationRepository = new ServiceConfigurationRepository();
