import { BaseRepository } from './base';
import { ServiceConfigurationDocument } from '../models/service-configuration';
export declare class ServiceConfigurationRepository extends BaseRepository<ServiceConfigurationDocument> {
    protected model: import("mongoose").Model<ServiceConfigurationDocument, {}, {}, {}, import("mongoose").Document<unknown, {}, ServiceConfigurationDocument, {}, {}> & ServiceConfigurationDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    constructor();
    getByKey(key: string, scope: 'global' | 'service' | 'provider' | 'plan', opts?: {
        serviceType?: string;
        providerId?: string;
        planId?: string;
    }): Promise<ServiceConfigurationDocument | null>;
    upsert(data: Omit<ServiceConfigurationDocument, 'id' | 'createdAt' | 'updatedAt'>): Promise<ServiceConfigurationDocument>;
    listByCategory(category: string): Promise<ServiceConfigurationDocument[]>;
}
export declare const serviceConfigurationRepository: ServiceConfigurationRepository;
