"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.publicationRepository = exports.PublicationRepository = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const base_1 = require("./base");
const publications_1 = require("../models/publications");
class PublicationRepository extends base_1.BaseRepository {
    model = publications_1.Publication;
    softDeleteEnabled = true;
    isValidId(id) {
        return mongoose_1.default.Types.ObjectId.isValid(id);
    }
    async findBySlug(slug) {
        return this.model.findOne({ slug });
    }
    async listPublishedByType(type, page = 1, limit = 10) {
        return this.findPaginated({ type, status: 'published' }, page, limit);
    }
}
exports.PublicationRepository = PublicationRepository;
exports.publicationRepository = new PublicationRepository();
