import mongoose from 'mongoose';
import { BaseRepository } from './base';
import { PublicationDocument, PublicationType } from '../models/publications';
export declare class PublicationRepository extends BaseRepository<PublicationDocument> {
    protected model: mongoose.Model<PublicationDocument, {}, {}, {}, mongoose.Document<unknown, {}, PublicationDocument, {}, {}> & PublicationDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    protected softDeleteEnabled: boolean;
    protected isValidId(id: string): boolean;
    findBySlug(slug: string): Promise<PublicationDocument | null>;
    listPublishedByType(type: PublicationType, page?: number, limit?: number): Promise<import("../models").PaginatedResult<PublicationDocument>>;
}
export declare const publicationRepository: PublicationRepository;
