"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductRepository = void 0;
const base_1 = require("./base");
const product_1 = require("../models/product");
class ProductRepository extends base_1.BaseRepository {
    model = product_1.Product;
    constructor() {
        super();
    }
    async findByCanonicalCode(canonicalCode) {
        return this.model.findOne({ canonicalCode, isDeleted: { $ne: true }, isVisible: true }).exec();
    }
    async findActiveByNetworkAndType(network, type, dataPlanType) {
        const query = { network, type, isVisible: true, isDeleted: { $ne: true } };
        if (type === 'data' && dataPlanType)
            query.dataPlanType = dataPlanType;
        return this.model.find(query).sort({ sellingPrice: 1, name: 1 }).exec();
    }
    async findDistinctDataPlanTypes() {
        const docs = await this.model.find({ type: 'data', isVisible: true, isDeleted: { $ne: true } }, { dataPlanType: 1 }).exec();
        const set = new Set();
        for (const d of docs) {
            const t = d?.dataPlanType;
            if (t)
                set.add(String(t));
        }
        return Array.from(set);
    }
}
exports.ProductRepository = ProductRepository;
