import { BaseRepository } from './base';
import { DisputeDocument } from '../models/dispute';
export declare class DisputeRepository extends BaseRepository<DisputeDocument> {
    protected model: import("mongoose").Model<DisputeDocument, {}, {}, {}, import("mongoose").Document<unknown, {}, DisputeDocument, {}, {}> & DisputeDocument & Required<{
        _id: unknown;
    }> & {
        __v: number;
    }, any>;
    isValidId(id: string): boolean;
    findByTransactionId(transactionId: string): Promise<DisputeDocument[]>;
    findActiveDisputes(): Promise<DisputeDocument[]>;
    findUrgentDisputes(): Promise<DisputeDocument[]>;
    findByType(type: string): Promise<DisputeDocument[]>;
    findByStatus(status: string): Promise<DisputeDocument[]>;
    update(disputeId: string, updateData: Partial<DisputeDocument>): Promise<DisputeDocument | null>;
    getDisputeStatsAggregation(): Promise<any[]>;
    getDisputeStats(): Promise<any[]>;
}
export declare const disputeRepository: DisputeRepository;
