"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.billPaymentRepository = exports.BillPaymentRepository = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const base_1 = require("./base");
const bills_1 = require("../models/bills");
class BillPaymentRepository extends base_1.BaseRepository {
    model = bills_1.BillPayment;
    softDeleteEnabled = true;
    isValidId(id) {
        return mongoose_1.default.Types.ObjectId.isValid(id);
    }
    async updateStatus(id, status, meta) {
        if (!this.isValidId(id))
            return;
        const update = { status };
        if (meta)
            update.metadata = meta;
        await this.model.updateOne({ _id: id }, { $set: update });
    }
    async findByProviderRef(providerReference) {
        return this.model.findOne({ providerReference });
    }
}
exports.BillPaymentRepository = BillPaymentRepository;
exports.billPaymentRepository = new BillPaymentRepository();
