import { BaseDocument, BaseCreateInput, BaseUpdateInput, PaginatedResult } from '../models/base';
export interface IBaseRepository<T extends BaseDocument> {
    create(data: BaseCreateInput): Promise<T>;
    findById(id: string): Promise<T | null>;
    find(filter?: Record<string, any>): Promise<T[]>;
    findOne(filter?: Record<string, any>): Promise<T | null>;
    updateById(id: string, data: BaseUpdateInput): Promise<T | null>;
    deleteById(id: string): Promise<boolean>;
    count(filter?: Record<string, any>): Promise<number>;
    exists(filter: Record<string, any>): Promise<boolean>;
    findPaginated(filter?: Record<string, any>, page?: number, limit?: number): Promise<PaginatedResult<T>>;
}
export declare abstract class BaseRepository<T extends BaseDocument> implements IBaseRepository<T> {
    protected abstract model: any;
    protected softDeleteEnabled: boolean;
    create(data: BaseCreateInput): Promise<T>;
    findById(id: string): Promise<T | null>;
    find(filter?: Record<string, any>): Promise<T[]>;
    findOne(filter?: Record<string, any>): Promise<T | null>;
    updateById(id: string, data: BaseUpdateInput): Promise<T | null>;
    deleteById(id: string): Promise<boolean>;
    softDelete(id: string): Promise<T | null>;
    count(filter?: Record<string, any>): Promise<number>;
    exists(filter: Record<string, any>): Promise<boolean>;
    findPaginated(filter?: Record<string, any>, page?: number, limit?: number): Promise<PaginatedResult<T>>;
    protected isValidId(_id: string): boolean;
    protected applySoftDeleteFilter(filter: Record<string, any>): Record<string, any>;
    getModel(): any;
}
