"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Withdrawal = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const withdrawalSchema = new mongoose_1.Schema({
    userId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User', required: true, index: true },
    walletId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Wallet', required: true, index: true },
    transactionId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Transaction', index: true },
    method: { type: String, enum: ['bank_transfer', 'card_withdrawal', 'mobile_money'], required: true, index: true },
    type: { type: String, enum: ['instant', 'scheduled'], default: 'instant', index: true },
    amount: { type: Number, required: true },
    currency: { type: String, enum: ['NGN', 'USD'], default: 'NGN' },
    fee: { type: Number, default: 0 },
    vat: { type: Number, default: 0 },
    netAmount: { type: Number, required: true },
    status: { type: String, enum: ['pending', 'processing', 'successful', 'failed', 'cancelled', 'reversed'], default: 'pending', index: true },
    reference: { type: String, required: true, unique: true, index: true },
    externalReference: { type: String },
    bankDetails: {
        bankName: String,
        accountNumber: String,
        accountName: String,
        narration: String,
    },
    cardDetails: {
        last4: String,
        brand: String,
    },
    mobileMoneyDetails: {
        provider: String,
        phoneNumber: String,
        accountName: String,
    },
    scheduledAt: { type: Date },
    processedAt: { type: Date },
    failedAt: { type: Date },
    failureReason: { type: String },
    reversalReason: { type: String },
    metadata: { type: mongoose_1.Schema.Types.Mixed },
}, base_1.baseSchemaOptions);
withdrawalSchema.index({ userId: 1, createdAt: -1 });
withdrawalSchema.index({ status: 1, method: 1, createdAt: -1 });
withdrawalSchema.index({ externalReference: 1 });
withdrawalSchema.index({ scheduledAt: 1, status: 1 });
exports.Withdrawal = mongoose_1.default.models['Withdrawal'] || mongoose_1.default.model('Withdrawal', withdrawalSchema);
