import { Document, Model, Types } from 'mongoose';
export type WithdrawalMethod = 'bank_transfer' | 'card_withdrawal' | 'mobile_money';
export type WithdrawalStatus = 'pending' | 'processing' | 'successful' | 'failed' | 'cancelled' | 'reversed';
export type WithdrawalType = 'instant' | 'scheduled';
export interface WithdrawalDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    walletId: Types.ObjectId;
    transactionId?: Types.ObjectId;
    method: WithdrawalMethod;
    type: WithdrawalType;
    amount: number;
    currency: 'NGN' | 'USD';
    fee: number;
    vat: number;
    netAmount: number;
    status: WithdrawalStatus;
    reference: string;
    externalReference?: string;
    bankDetails?: {
        bankName: string;
        accountNumber: string;
        accountName: string;
        narration?: string;
    };
    cardDetails?: {
        last4: string;
        brand: string;
    };
    mobileMoneyDetails?: {
        provider: string;
        phoneNumber: string;
        accountName: string;
    };
    scheduledAt?: Date;
    processedAt?: Date;
    failedAt?: Date;
    failureReason?: string;
    reversalReason?: string;
    metadata?: Record<string, any>;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Withdrawal: Model<WithdrawalDocument>;
