import { Document, Model, Types } from 'mongoose';
export interface WalletDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    currency: 'NGN' | 'USD';
    availableBalance: number;
    ledgerBalance: number;
    status: 'active' | 'frozen' | 'closed';
    lastTransactionAt?: Date;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Wallet: Model<WalletDocument>;
