import { Document, Model, Types } from 'mongoose';
export type VtuType = 'airtime' | 'data';
export type Network = 'mtn' | 'airtel' | 'glo' | '9mobile';
export type VtuStatus = 'pending' | 'processing' | 'successful' | 'failed';
export interface VtuOrderDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    transactionId?: Types.ObjectId;
    type: VtuType;
    network: Network;
    phone: string;
    amount: number;
    planCode?: string;
    status: VtuStatus;
    provider: 'paystack' | 'flutterwave' | 'asbdata' | 'mock' | 'others' | 'configurable';
    providerReference?: string;
    metadata?: Record<string, any>;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const VtuOrder: Model<VtuOrderDocument>;
