import { Document, Model, Types } from 'mongoose';
export type VerificationType = 'bvn' | 'nin' | 'bvn_phone' | 'bvn_name' | 'others';
export type VerificationStatus = 'pending' | 'processing' | 'verified' | 'failed';
export interface VerificationRequestDocument extends Document {
    id: string;
    userId: Types.ObjectId;
    type: VerificationType;
    target: string;
    status: VerificationStatus;
    provider: 'bvn' | 'nimc' | 'others';
    providerReference?: string;
    result?: Record<string, any>;
    errorMessage?: string;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const VerificationRequest: Model<VerificationRequestDocument>;
