"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transaction = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const transactionSchema = new mongoose_1.Schema({
    userId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User', index: true },
    walletId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Wallet', index: true },
    reference: { type: String, required: true, unique: true, index: true },
    type: { type: String, enum: ['credit', 'debit'], required: true },
    category: { type: String, enum: ['funding', 'withdrawal', 'transfer', 'bill_payment', 'vtu', 'refund', 'fee', 'reversal', 'chargeback'], required: true, index: true },
    amount: { type: Number, required: true },
    currency: { type: String, enum: ['NGN', 'USD'], default: 'NGN' },
    balanceBefore: { type: Number },
    balanceAfter: { type: Number },
    feeAmount: { type: Number, default: 0 },
    vatAmount: { type: Number, default: 0 },
    netAmount: { type: Number },
    journalEntryId: { type: String },
    status: { type: String, enum: ['pending', 'processing', 'successful', 'failed', 'reversed', 'cancelled'], default: 'pending', index: true },
    description: { type: String, trim: true },
    metadata: { type: mongoose_1.Schema.Types.Mixed },
    externalReference: { type: String, trim: true, index: true },
    relatedTransactionId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'Transaction', index: true },
    isReversal: { type: Boolean, default: false, index: true },
}, base_1.baseSchemaOptions);
transactionSchema.index({ userId: 1, createdAt: -1 });
transactionSchema.index({ walletId: 1, createdAt: -1 });
transactionSchema.index({ category: 1, status: 1, createdAt: -1 });
transactionSchema.index({ journalEntryId: 1 });
transactionSchema.index({ isReversal: 1, relatedTransactionId: 1 });
exports.Transaction = mongoose_1.default.models['Transaction'] || mongoose_1.default.model('Transaction', transactionSchema);
