import { Document, Model, Types } from 'mongoose';
export type TransactionType = 'credit' | 'debit';
export type TransactionCategory = 'funding' | 'withdrawal' | 'transfer' | 'bill_payment' | 'vtu' | 'refund' | 'fee' | 'reversal' | 'chargeback';
export type TransactionStatus = 'pending' | 'processing' | 'successful' | 'failed' | 'reversed' | 'cancelled';
export interface TransactionDocument extends Document {
    id: string;
    userId?: Types.ObjectId;
    walletId?: Types.ObjectId;
    reference: string;
    type: TransactionType;
    category: TransactionCategory;
    amount: number;
    currency: 'NGN' | 'USD';
    balanceBefore?: number;
    balanceAfter?: number;
    feeAmount?: number;
    vatAmount?: number;
    netAmount?: number;
    journalEntryId?: string;
    status: TransactionStatus;
    description?: string;
    metadata?: Record<string, any>;
    externalReference?: string;
    relatedTransactionId?: Types.ObjectId;
    isReversal?: boolean;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Transaction: Model<TransactionDocument>;
