"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceProvider = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const field_encryption_1 = require("../../core/security/field-encryption");
const serviceProviderSchema = new mongoose_1.Schema({
    name: { type: String, required: true, trim: true },
    slug: { type: String, required: true, unique: true, trim: true, lowercase: true },
    displayName: { type: String, required: true, trim: true },
    serviceType: {
        type: String,
        enum: ['vtu', 'bills', 'verification', 'payment'],
        required: true,
        index: true
    },
    status: {
        type: String,
        enum: ['active', 'inactive', 'maintenance'],
        default: 'active',
        index: true
    },
    baseUrl: { type: String, required: true, trim: true },
    apiKey: { type: String, required: true },
    secretKey: { type: String },
    webhookUrl: { type: String, trim: true },
    timeout: { type: Number, default: 30000 },
    retryAttempts: { type: Number, default: 3 },
    sandboxMode: { type: Boolean, default: false },
    priority: { type: Number, default: 1, index: true },
    rateLimitPerMinute: { type: Number },
    rateLimitPerHour: { type: Number },
    defaultMarkup: { type: Number, default: 0 },
    minimumBalance: { type: Number },
    isHealthy: { type: Boolean, default: true, index: true },
    lastHealthCheck: { type: Date },
    errorCount: { type: Number, default: 0 },
    successRate: { type: Number, default: 100 },
    supportedServices: [{ type: String, trim: true }],
    supportedNetworks: [{ type: String, trim: true }],
    isDeleted: { type: Boolean, default: false, index: true },
    deletedAt: { type: Date },
}, base_1.baseSchemaOptions);
serviceProviderSchema.index({ serviceType: 1, status: 1, priority: 1 });
serviceProviderSchema.index({ slug: 1, isDeleted: 1 });
serviceProviderSchema.index({ supportedServices: 1, status: 1 });
serviceProviderSchema.plugin(field_encryption_1.encryptedFieldsPlugin, {
    fields: ['apiKey', 'secretKey']
});
exports.ServiceProvider = mongoose_1.default.models['ServiceProvider'] || mongoose_1.default.model('ServiceProvider', serviceProviderSchema);
