import { Document, Model } from 'mongoose';
export type ServiceType = 'vtu' | 'bills' | 'verification' | 'payment';
export type ProviderStatus = 'active' | 'inactive' | 'maintenance';
export interface ServiceProviderDocument extends Document {
    id: string;
    name: string;
    slug: string;
    displayName: string;
    serviceType: ServiceType;
    status: ProviderStatus;
    baseUrl: string;
    apiKey: string;
    secretKey?: string;
    webhookUrl?: string;
    timeout: number;
    retryAttempts: number;
    sandboxMode: boolean;
    priority: number;
    rateLimitPerMinute?: number;
    rateLimitPerHour?: number;
    defaultMarkup: number;
    minimumBalance?: number;
    isHealthy: boolean;
    lastHealthCheck?: Date;
    errorCount: number;
    successRate: number;
    supportedServices: string[];
    supportedNetworks?: string[];
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const ServiceProvider: Model<ServiceProviderDocument>;
