"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicePlan = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const servicePlanSchema = new mongoose_1.Schema({
    providerId: { type: mongoose_1.Schema.Types.ObjectId, ref: 'ServiceProvider', required: true, index: true },
    planId: { type: String, required: true, trim: true },
    vendorPlanId: { type: String, trim: true },
    name: { type: String, required: true, trim: true },
    description: { type: String, trim: true },
    type: {
        type: String,
        enum: ['data', 'airtime', 'electricity', 'cable', 'education', 'exam-pin'],
        required: true,
        index: true
    },
    category: { type: String, trim: true, index: true },
    network: {
        type: String,
        enum: ['mtn', 'airtel', 'glo', '9mobile'],
        index: true
    },
    dataPlanType: {
        type: String,
        enum: ['sme', 'sme2', 'corporate', 'awoof', 'gifting'],
        index: true
    },
    size: { type: String, trim: true },
    validity: { type: String, trim: true },
    amount: { type: Number, required: true },
    sellingPrice: { type: Number, required: true },
    status: {
        type: String,
        enum: ['active', 'inactive', 'out-of-stock'],
        default: 'active',
        index: true
    },
    isVisible: { type: Boolean, default: true, index: true },
    stockQuantity: { type: Number },
    minPurchase: { type: Number },
    maxPurchase: { type: Number },
    dailyLimit: { type: Number },
    portedNumber: { type: Boolean, default: true },
    metadata: { type: mongoose_1.Schema.Types.Mixed, default: {} },
    totalSales: { type: Number, default: 0 },
    successRate: { type: Number, default: 100 },
    lastSaleDate: { type: Date },
    isDeleted: { type: Boolean, default: false, index: true },
    deletedAt: { type: Date },
}, base_1.baseSchemaOptions);
servicePlanSchema.index({ type: 1, network: 1, status: 1, isVisible: 1 });
servicePlanSchema.index({ providerId: 1, type: 1, status: 1 });
servicePlanSchema.index({ planId: 1, providerId: 1 }, { unique: true });
servicePlanSchema.index({ sellingPrice: 1, type: 1, network: 1 });
servicePlanSchema.index({
    name: 'text',
    description: 'text',
    'metadata.discoName': 'text',
    'metadata.cableName': 'text'
});
exports.ServicePlan = mongoose_1.default.models['ServicePlan'] || mongoose_1.default.model('ServicePlan', servicePlanSchema);
