import { Document, Model, Types } from 'mongoose';
export type PlanType = 'data' | 'airtime' | 'electricity' | 'cable' | 'education' | 'exam-pin';
export type DataPlanType = 'sme' | 'sme2' | 'corporate' | 'awoof' | 'gifting';
export type Network = 'mtn' | 'airtel' | 'glo' | '9mobile';
export type PlanStatus = 'active' | 'inactive' | 'out-of-stock';
export interface ServicePlanDocument extends Document {
    id: string;
    providerId: Types.ObjectId;
    planId: string;
    vendorPlanId?: string;
    name: string;
    description?: string;
    type: PlanType;
    category?: string;
    network?: Network;
    dataPlanType?: DataPlanType;
    size?: string;
    validity?: string;
    amount: number;
    sellingPrice: number;
    status: PlanStatus;
    isVisible: boolean;
    stockQuantity?: number;
    minPurchase?: number;
    maxPurchase?: number;
    dailyLimit?: number;
    portedNumber?: boolean;
    metadata: {
        discoId?: string;
        discoName?: string;
        cableId?: string;
        cableName?: string;
        packageName?: string;
        examType?: string;
        institution?: string;
        [key: string]: any;
    };
    totalSales: number;
    successRate: number;
    lastSaleDate?: Date;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const ServicePlan: Model<ServicePlanDocument>;
