"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceConfiguration = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const serviceConfigurationSchema = new mongoose_1.Schema({
    key: { type: String, required: true, trim: true },
    scope: {
        type: String,
        enum: ['global', 'service', 'provider', 'plan'],
        required: true,
        index: true
    },
    type: {
        type: String,
        enum: ['string', 'number', 'boolean', 'object', 'array'],
        required: true
    },
    serviceType: { type: String, trim: true, index: true },
    providerId: { type: String, trim: true, index: true },
    planId: { type: String, trim: true, index: true },
    value: { type: mongoose_1.Schema.Types.Mixed, required: true },
    defaultValue: { type: mongoose_1.Schema.Types.Mixed },
    name: { type: String, required: true, trim: true },
    description: { type: String, trim: true },
    category: { type: String, trim: true, index: true },
    validation: {
        required: { type: Boolean, default: false },
        min: { type: Number },
        max: { type: Number },
        pattern: { type: String },
        enum: [{ type: String }],
    },
    isPublic: { type: Boolean, default: false, index: true },
    isEditable: { type: Boolean, default: true, index: true },
    lastModifiedBy: { type: String, trim: true },
    isDeleted: { type: Boolean, default: false, index: true },
    deletedAt: { type: Date },
}, base_1.baseSchemaOptions);
serviceConfigurationSchema.index({
    key: 1,
    scope: 1,
    serviceType: 1,
    providerId: 1,
    planId: 1
}, {
    unique: true,
    partialFilterExpression: { isDeleted: { $ne: true } }
});
serviceConfigurationSchema.index({ scope: 1, isPublic: 1, isDeleted: 1 });
serviceConfigurationSchema.index({ category: 1, scope: 1 });
exports.ServiceConfiguration = mongoose_1.default.models['ServiceConfiguration'] || mongoose_1.default.model('ServiceConfiguration', serviceConfigurationSchema);
