import { Document, Model } from 'mongoose';
export type ConfigScope = 'global' | 'service' | 'provider' | 'plan';
export type ConfigType = 'string' | 'number' | 'boolean' | 'object' | 'array';
export interface ServiceConfigurationDocument extends Document {
    id: string;
    key: string;
    scope: ConfigScope;
    type: ConfigType;
    serviceType?: string;
    providerId?: string;
    planId?: string;
    value: any;
    defaultValue?: any;
    name: string;
    description?: string;
    category?: string;
    validation?: {
        required?: boolean;
        min?: number;
        max?: number;
        pattern?: string;
        enum?: string[];
    };
    isPublic: boolean;
    isEditable: boolean;
    lastModifiedBy?: string;
    isDeleted?: boolean;
    deletedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const ServiceConfiguration: Model<ServiceConfigurationDocument>;
