"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reconciliation = void 0;
const mongoose_1 = __importStar(require("mongoose"));
const base_1 = require("./base");
const reconciliationSchema = new mongoose_1.Schema({
    type: { type: String, enum: ['daily', 'weekly', 'monthly', 'manual'], required: true, index: true },
    status: { type: String, enum: ['pending', 'in_progress', 'completed', 'failed', 'discrepancy_found'], default: 'pending', index: true },
    provider: { type: String, required: true, index: true },
    dateFrom: { type: Date, required: true, index: true },
    dateTo: { type: Date, required: true, index: true },
    totalTransactions: { type: Number, default: 0 },
    totalAmount: { type: Number, default: 0 },
    currency: { type: String, enum: ['NGN', 'USD'], default: 'NGN' },
    matchedTransactions: { type: Number, default: 0 },
    matchedAmount: { type: Number, default: 0 },
    discrepancies: [{
            type: { type: String, enum: ['missing_transaction', 'amount_mismatch', 'status_mismatch', 'duplicate_transaction'] },
            internalReference: String,
            externalReference: String,
            internalAmount: Number,
            externalAmount: Number,
            internalStatus: String,
            externalStatus: String,
            description: String,
            resolved: { type: Boolean, default: false },
            resolvedAt: Date,
            resolvedBy: { type: mongoose_1.Schema.Types.ObjectId, ref: 'User' },
        }],
    summary: {
        totalProcessed: { type: Number, default: 0 },
        totalSuccessful: { type: Number, default: 0 },
        totalFailed: { type: Number, default: 0 },
        totalReversed: { type: Number, default: 0 },
        totalFees: { type: Number, default: 0 },
        totalVat: { type: Number, default: 0 },
    },
    metadata: { type: mongoose_1.Schema.Types.Mixed },
    startedAt: { type: Date, default: Date.now },
    completedAt: { type: Date },
}, base_1.baseSchemaOptions);
reconciliationSchema.index({ provider: 1, dateFrom: 1, dateTo: 1 });
reconciliationSchema.index({ status: 1, type: 1, createdAt: -1 });
reconciliationSchema.index({ 'discrepancies.resolved': 1 });
exports.Reconciliation = mongoose_1.default.models['Reconciliation'] || mongoose_1.default.model('Reconciliation', reconciliationSchema);
