import { Document, Model, Types } from 'mongoose';
export type ReconciliationType = 'daily' | 'weekly' | 'monthly' | 'manual';
export type ReconciliationStatus = 'pending' | 'in_progress' | 'completed' | 'failed' | 'discrepancy_found';
export type DiscrepancyType = 'missing_transaction' | 'amount_mismatch' | 'status_mismatch' | 'duplicate_transaction';
export interface ReconciliationDocument extends Document {
    id: string;
    type: ReconciliationType;
    status: ReconciliationStatus;
    provider: string;
    dateFrom: Date;
    dateTo: Date;
    totalTransactions: number;
    totalAmount: number;
    currency: 'NGN' | 'USD';
    matchedTransactions: number;
    matchedAmount: number;
    discrepancies: Array<{
        type: DiscrepancyType;
        internalReference: string;
        externalReference?: string;
        internalAmount: number;
        externalAmount?: number;
        internalStatus: string;
        externalStatus?: string;
        description: string;
        resolved: boolean;
        resolvedAt?: Date;
        resolvedBy?: Types.ObjectId;
    }>;
    summary: {
        totalProcessed: number;
        totalSuccessful: number;
        totalFailed: number;
        totalReversed: number;
        totalFees: number;
        totalVat: number;
    };
    metadata?: Record<string, any>;
    startedAt: Date;
    completedAt?: Date;
    createdAt: Date;
    updatedAt: Date;
}
export declare const Reconciliation: Model<ReconciliationDocument>;
